(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4424,        141]*)
(*NotebookOutlinePosition[      5066,        163]*)
(*  CellTagsIndexPosition[      5022,        159]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(Plot[
      Evaluate[Table[
          x^{2\ \ i}/\((1 + x^{2\ \ i})\), {i, 1, 6}]], {x, \(-2\), 2}, 
      PlotRange \[Rule] All]\)], "Input"],

Cell[BoxData[
    \(graf1 = 
      Plot[Evaluate[Table[i\ x\ \((1 - x)\)^i, {i, 1, 6}]], {x, 0, 1}, 
        PlotRange \[Rule] {0,  .35}]\)], "Input"],

Cell[BoxData[
    \(Display["\<ejemplo1.eps\>", graf1, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    \(f10 = 
      Plot[10\ x \((1 - x)\)^10, {x, 0, 1}, PlotRange \[Rule] {0,  .37}, 
        Ticks -> {Automatic, None}]\)], "Input"],

Cell[BoxData[
    \(f20 = 
      Plot[20\ x \((1 - x)\)^20, {x, 0, 1}, PlotRange \[Rule] {0,  .37}, 
        PlotPoints \[Rule] 100, Ticks -> {Automatic, None}]\)], "Input"],

Cell[BoxData[
    \(graf2 = 
      Show[GraphicsArray[{f10, f20}], 
        ImageSize \[Rule] {606, 178.313}]\)], "Input"],

Cell[BoxData[
    \(Display["\<ejemplo2.eps\>", graf2, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    \(Clear[f]\)], "Input"],

Cell[BoxData[
    \(f[x_] := n\ x\ \((1 - x)\)^n\)], "Input"],

Cell[BoxData[
    \(Simplify[\(f'\)[x]]\)], "Input"],

Cell[BoxData[
    \(Simplify[f[x] /. x \[Rule] 1/\((n + 1)\)]\)], "Input"],

Cell[BoxData[
    \(\(graf3 = 
        Plot[Evaluate[Table[i\ x\ \((1 - x)\)^i, {i, 100, 200, 20}]], {x, 
            0,  .1}, PlotRange \[Rule] {0,  .38}, 
          PlotPoints \[Rule] 100];\)\)], "Input"],

Cell[BoxData[
    \(Display["\<ejemplo3.eps\>", graf3, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    \(graf4 = 
      Plot[Evaluate[
          Table[x^{2  i}/\ \((1 + x^{2  i})\), {i, 1, 5}]], {x, \(-2.5\), 
          2.5}, PlotRange \[Rule] {0, 1.1}, AspectRatio \[Rule] 1/3, 
        ImageSize \[Rule] {475, 158.063}, PlotPoints \[Rule] 100]\)], "Input"],

Cell[BoxData[
    \(Display["\<ejemplo4.eps\>", graf4, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    \(<< Utilities`FilterOptions`\)], "Input"],

Cell[BoxData[
    \(PlotIntegrate[f_, {x_, a_, b_}, opts___] := 
      With[{optPlot = FilterOptions[Plot, opts], 
          optNInt = FilterOptions[NIntegrate, opts]}, 
        Plot[NIntegrate[f, {x, a, t}, optNInt], {t, a, b}, 
          optPlot]]\)], "Input"],

Cell[BoxData[
    \(graf5 = 
      Plot[Evaluate[Table[i^{2} x\ Exp[\(-i\)\ x], {i, 1, 5}]], {x, 0, 1.5}, 
        PlotRange \[Rule] {0, 2}]\)], "Input"],

Cell[BoxData[
    \(Display["\<ejemplo5.eps\>", graf5, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    \(Integrate[n^2\ x\ Exp[\(-x\)\ n], x]\)], "Input"],

Cell[BoxData[
    \(FullSimplify[\((\[ExponentialE]\^\(\(-n\)\ x\)\ n\^2\ \((\(-\(1\/n\^2\)\
\) - x\/n)\) /. 
            x \[Rule] 
              1)\) - \((\[ExponentialE]\^\(\(-n\)\ x\)\ n\^2\ \((\(-\(1\/n\^2\
\)\) - x\/n)\) /. x \[Rule] 0)\)]\)], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{792, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 162, 4, 30, "Input"],
Cell[1870, 56, 150, 3, 30, "Input"],
Cell[2023, 61, 78, 1, 30, "Input"],
Cell[2104, 64, 149, 3, 30, "Input"],
Cell[2256, 69, 173, 3, 30, "Input"],
Cell[2432, 74, 122, 3, 30, "Input"],
Cell[2557, 79, 78, 1, 30, "Input"],
Cell[2638, 82, 41, 1, 30, "Input"],
Cell[2682, 85, 61, 1, 30, "Input"],
Cell[2746, 88, 52, 1, 30, "Input"],
Cell[2801, 91, 74, 1, 30, "Input"],
Cell[2878, 94, 206, 4, 50, "Input"],
Cell[3087, 100, 78, 1, 30, "Input"],
Cell[3168, 103, 273, 5, 50, "Input"],
Cell[3444, 110, 78, 1, 30, "Input"],
Cell[3525, 113, 60, 1, 30, "Input"],
Cell[3588, 116, 262, 5, 70, "Input"],
Cell[3853, 123, 153, 3, 30, "Input"],
Cell[4009, 128, 78, 1, 30, "Input"],
Cell[4090, 131, 69, 1, 30, "Input"],
Cell[4162, 134, 258, 5, 42, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

